/**
 * <h1>clientRest</h1>
 *
 * <BLOCKQUOTE>
 *     This project is a use example for the "Openness API" for Alcatel-Lucent's OpenTouch product.<br>
 *     Full use from the API is not the project's aim, it is only an entry point for people wanting to use the OT public API.
 *     <p>
 *     <br>
 *     Here is a short view from the project structure.
 * </BLOCKQUOTE>
 *
 * <p>
 *
 * <h2><code>java.sample.application</code></h2>
 * <BLOCKQUOTE>
 *     Package containing code sample(s), can be used as project entry point.<br>
 *     Each sample can be run independently. This cutting is done on purpose to ease the understanding.<br>
 *     <BLOCKQUOTE>
 *         <t>For <b>basic telephony</b> : Sample1 introduces Sample2 which itself introduces Sample3.<br>
 *         For <b>keep alive mechanisms</b> : Sample4 introduces Sample5
 *     </BLOCKQUOTE>
 *     <p><br>
 *     <code><b>Sample1MakeCall</b></code><br>
 *     <BLOCKQUOTE>
 *         This sample shows the most simple make call scenario, its code is used as a base for following samples.<br>
 *         The scenario is : Alice calls Bob, which rings and then Alice releases the call without Bob's answer.<br>
 *         It implements base mechanisms to make authentication, open session, make call, call release and then close session.
 *     </BLOCKQUOTE>
 *     <p><br>
 *     <code><b>Sample2Subscription</b></code><br>
 *     <BLOCKQUOTE>
 *         This sample is based on Sample1MakeCall, it adds the subscription to telephonic events (for the caller only).
 *         The caller then extracts, from the first telephonic event, the call reference which is used to release the call.<br>
 *         The scenario is the same than in Sample1MakeCall : Alice calls Bob, which rings and then Alice releases the call
 *         (using the call reference) without Bob's answer.
 *     </BLOCKQUOTE>
 *     <p><br>
 *     <code><b>Sample3AnsweredCall</b></code><br>
 *     <BLOCKQUOTE>
 *         This sample is based on the Sample1MakeCall, it adds the subscription to telephonic events (for the callee only),
 *         and the call answering.<br>
 *         The scenario begins as in Sample1MakeCall (Alice calls Bob, which rings), but then changes as Bob answers the
 *         call, waits, and releases it. It's now Bob which has subscribed to telephonic events in order to handle the
 *         incoming call.
 *     </BLOCKQUOTE>
 *     <p><br>
 *     <code><b>Sample4SessionKeepAlive</b></code><br>
 *     <BLOCKQUOTE>
 *         This sample focuses on maintaining a session open.<br>
 *         Once opened, a session has a limited time life period. The duration is a server value which is retrieved at session
 *         opening.<br>
 *         But the session is also maintained open by each "session access" (which restarts this timer on server's side, so
 *         client timer has also to be restarted (to not over load the server with unnecessary requests). Note that this
 *         mechanism is not handled in this sample.<br>
 *         <br>
 *         Only one user is used for this sample, it authenticates and opens a session.<br>
 *         The session time to live duration is get at the opening and used in a periodic activated thread. Then each time the
 *         thread is activated, it refreshes the session. This scenario will stop itself only after 24 hours.<br>
 *         <br>
 *         Note that in this example, only a keep alive from the session is shown. See Sample5SubscriptionKeepAlive for
 *         event subscription keep alive.
 *     </BLOCKQUOTE>
 *     <p><br>
 *     <code><b>Sample5SubscriptionKeepAlive</b></code><br>
 *     <BLOCKQUOTE>
 *         This sample enhances Sample4SessionKeepAlive by adding the keep alive from an events subscription.<br>
 *         <br>
 *         The keep alive for events subscription is a little bit different than the session's one: once subscribed the timer
 *         ending will stop the subscription even if events are received. The client waits till the socket connection is closed,
 *         and then, if it restarts the chunk within 1 minute, it will not lose event(s) because the server retains them (only
 *         during this minute).
 *     </BLOCKQUOTE>
 *     <p><br>
 *     <code><b>Sample6CommunicationLog</b></code><br>
 *     <BLOCKQUOTE>
 *         This sample shows a subscription to (and reception from) a communication log event. It re-uses mechanisms shown in
 *         previous samples like make call and event subscription.<br>
 *         <br>
 *         Two users are used for this example (caller and callee) and both are opening a subscription : the caller to
 *         telephonic events and the callee to communication log events. The subscriptions only differ at the subscription
 *         address.<br>
 *         The 1st user calls the 2nd user, which doesn't answer. After a short waiting the caller hangs-up and the callee will
 *         receive a <i>missed call</i> event through its subscription.
 *     </BLOCKQUOTE>
 *     <p><br>
 *     <code><b>Important note</b></code><br>
 *     <BLOCKQUOTE>
 *         To be able to make all these sample work, the used devices have to correctly support the 3PCC. In some cases it's also
 *         easier to put a device in auto-answering mode (but caution, do not use this auto-answer mode when the callee has to
 *         not answer the incoming call).
 *     </BLOCKQUOTE>
 * </BLOCKQUOTE>
 *
 * <p>
 *
 * <h2><code>java.sample.config</code></h2>
   <BLOCKQUOTE>
 *     Tools to access configuration files.
 *     <p><br>
 *     <code><b>ApiConfig</b></code>
 *     <BLOCKQUOTE>
 *         API specific configuration.
 *     </BLOCKQUOTE>
 *     <p>
 *     <code><b>ConfigReader</b></code>
 *     <BLOCKQUOTE>
 *         file reader helper.
 *     </BLOCKQUOTE>
 *     <p>
 *     <code><b>UserConfig</b></code>
 *     <BLOCKQUOTE>
 *         used to read user specific configuration.
 *     </BLOCKQUOTE>
 * </BLOCKQUOTE>
 *
 * <p>
 *
 * <h2><code>java.sample.core</code></h2>
 * <BLOCKQUOTE>
 *     Core API functions.
 *     <p><br>
 *     <code><b>exception</b></code><br>
 *     <BLOCKQUOTE>
 *         OTRestClientException.
 *     </BLOCKQUOTE>
 *     <p>
 *     <code><b>Authentication</b></code><br>
 *     <BLOCKQUOTE>
 *         Authentication is done in several steps and this class hides this complexity.
 *     </BLOCKQUOTE>
 *     <p>
 *     <code><b>CallControl</b></code><br>
 *     <BLOCKQUOTE>
 *         Class containing telephonic methods permitting the control from a call (<code>makeCallRequest</code> and
 *     <code>releaseAllCallsRequest</code> for instance).
 *     </BLOCKQUOTE>
 *     <p>
 *     <code><b>ClientSession</b></code><br>
 *     <BLOCKQUOTE>
 *         Session is mandatory in order to handle accesses rights.
 *     </BLOCKQUOTE>
 *     <p>
 *     <code><b>ClientSubscription</b></code><br>
 *     <BLOCKQUOTE>
 *         To be able to receive unsolicited messages (like telephony events), a user has to open an event subscription.
 *     </BLOCKQUOTE>
 * </BLOCKQUOTE>
 *
 * <p>
 *
 * <h2><code>java.sample.rest</code></h2>
 * <BLOCKQUOTE>
 *     <code><b>data.v1_0</b></code><br>
 *     <BLOCKQUOTE>
 *         The "Open Touch - REST API" document describes in details data needed by the API. The data, in JSON form, are
 *         described as java objects in this package.<br>
 *         Note that the data names follow the documentation names.<br>
 *         Only classes used in this project are given here.
 *     </BLOCKQUOTE>
 *     <p>
 *     <code><b>resources</b></code><br>
 *     <BLOCKQUOTE>
 *         Resources used by Event subscription, Services, Session and Telephony to access Rest interface.
 *     </BLOCKQUOTE>
 * </BLOCKQUOTE>
 *
 * <p>
 * <h2><code>java.sample.transport</code></h2>
 * <BLOCKQUOTE>
 *     <a href="https://jersey.java.net/">Jersey</a> is used as the sample.transport layer to access the OT server through http
 *     requests.
 *     <p><br>
 *     <code><b>JerseyClient</b></code><br>
 *     <BLOCKQUOTE>
 *         Class used to build our Jersey client.
 *     </BLOCKQUOTE>
 *     <p>
 *     <code><b>JerseyRequests</b></code><br>
 *     <BLOCKQUOTE>
 *         Basic Jersey requests (POST, GET ...).
 *     </BLOCKQUOTE>
 * </BLOCKQUOTE>
 *
 * <p>
 * <h2><code>resources</code></h2>
 * <BLOCKQUOTE>
 *     - Configuration file containing sample.config needed to access the server and its users.
 *     <p>
 *     - Log4j configuration file.
 * </BLOCKQUOTE>
 */