package sample.rest.resources;

import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;

import sample.core.exception.OTRestClientException;
import sample.rest.data.v1_0.sessionschema.SessionInfo;
import sample.rest.data.v1_0.sessionschema.SessionRequest;
import sample.transport.JerseyRequests;

/**
 * <pre>
 *  Rest level for session handling.
 *  Session requests are Rest formatted.
 * </pre>
 */
public class Session {

    private static final String APPLICATION_NAME = "TEST_API";
    
    public SessionInfo openSession(String path, Cookie cookie) throws OTRestClientException {

        SessionRequest sessionRequest = new SessionRequest();
        sessionRequest.setApplicationName(APPLICATION_NAME);
        Response response = JerseyRequests.post(path, cookie, sessionRequest, Response.Status.OK);
        return response.readEntity(SessionInfo.class);
    }

    public void keepAlive(String path, Cookie cookie) throws OTRestClientException {

        String keepalivePath = path + "/keepalive";
        SessionRequest sessionRequest = new SessionRequest();
        sessionRequest.setApplicationName(APPLICATION_NAME);
        JerseyRequests.post(keepalivePath, cookie, sessionRequest, Response.Status.NO_CONTENT);
    }

    public void closeSession(String path, Cookie cookie) throws OTRestClientException {

        JerseyRequests.delete(path, cookie, Response.Status.NO_CONTENT);
    }
}
